set more off
pause off
set level 90
graph set window fontface "Times New Roman"
cap log close

sort gvkeyn qdate

global HORIZON  = 20 

by gvkeyn : gen firmlife = _N

global LAGS =  4 

cap drop f*
cap drop lag*

if "$response" == "invratio" {
	
drop if cyear < 1986 

global rscalelabelmainx "yscale(r(-0.5 0.25)) ylabel(-0.5(0.25)0.25, labsize(large))" 
}

if "$response" == "lnRealSales" {

global rscalelabelmainx "yscale(r(-2 2)) ylabel(-2(1)2, labsize(large))" 

}

if "$response" == "lnempC"  {
global rscalelabelmainx "yscale(r(-1 1)) ylabel(-1(0.5)1, labsize(large))" 

}

sort gvkeyn qdate

foreach y in $response {

	forvalues h=0/${HORIZON} {
		
		qui: by gvkeyn: gen f`h'`y' =  F`h'.`y' - L.`y'

	}

}


foreach y in $instrument {

	forvalues h=18/${HORIZON} {
		
		qui: by gvkeyn: gen f`h'`y' =  F`h'.`y' - L.`y'
		
	}
}


foreach y in $policy_variable {
		
	forvalues h=0/${HORIZON} {
		
		qui: gen f`h'`y' = F`h'.`y' - L.`y'
		
	}	
}


foreach y in $controls {		

	forvalues i=1/${LAGS} {
		
		qui: gen lag`i'`y' = L`i'.`y'
		global lagsAll ${lagsAll} lag`i'`y'
				
	}
}

sort gvkeyn qdate
cap drop horizon
gen horizon = _n - 1 if _n<= $HORIZON + 1

cap drop firmtag
egen firmtag = tag(gvkeyn) 
count if firmtag 

*********
*** GENERATING THE EMPTY VARIABLES TO STORE COEFFICIENTS AND STD ERRORS
*********	

	foreach y in $response {	
	forval k = 1/$nq {

	gen ir`k'_`y'_IV = .
	gen se`k'_`y'_IV = .
	
	gen ir`k'_`y'_IVp = .
	gen ir`k'_`y'_IVn = .
	gen se`k'_`y'_IVp = .
	gen se`k'_`y'_IVn = .
	
	}
	}
	

cap drop samp2

reg f${HORIZON}${instrument} ${instrument}
gen samp2 = e(sample)


* 0 - AVERAGE WITHOUT SIGN SPLIT

foreach y in $response {

	forv h = 0/$HORIZON {

ivreghdfe f`h'`y' $lagsAll Trend (c.${policy_variable} = c.${instrument}) if samp == 1, cluster(gvkeyn qdate) absorb(gvkeyn) bw(16)

	
replace ir1_`y'_IV =  _b[${policy_variable}] if horizon==`h'  
replace se1_`y'_IV =  _se[${policy_variable}] if horizon==`h'

	}
}


timer clear
timer on 1


* GRAPHING IMPULSE RESPONSES 

capture drop horizon
capture drop zero

gen horizon = _n - 1 
* zero line
gen zero = 0 if _n <= $HORIZON +1

* Create confidence bands
scalar sig1 = 0.05
scalar sig2 = 0.1

capture drop up*
capture drop dn*


foreach y in $response {
	forval k = 1/$nq {

local PLOTH = ${HORIZON} + 1

gen up`k'_`y'_IV = ir`k'_`y'_IV + invnormal(1-sig2/2)*se`k'_`y'_IV if (inrange(horizon,0,`PLOTH'))
gen dn`k'_`y'_IV = ir`k'_`y'_IV - invnormal(1-sig2/2)*se`k'_`y'_IV if (inrange(horizon,0,`PLOTH'))

graph twoway (rarea up`k'_`y'_IV dn`k'_`y'_IV horizon, ${rscalelabelmainx}  fcolor(gs13) lcolor(white) lpattern(solid))  ///
	(scatter ir`k'_`y'_IV horizon, ${rscalelabelmainx} connect(1) lcolor(dknavy) lwidth(medthick) msymbol(o) msize(medium) mcolor(blue)) ///
	(line zero horizon, lcolor(black)) if inrange(horizon,0,`PLOTH'), ///
	ytitle("`: variable label `y'' ", size(large)) xtitle("Horizon (Quarters)", size(large)) xlab(0 4 8 12 16, labsize(large)) ///
	graphregion(color(white)) plotregion(color(white)) legend(off) name(IV_`y'_`k',replace)  ///
	
graph export "${mainpath}/Figures/IR/Micro LPs/Pooled/ir_IV_`y'_`k'_${capx}_${instrument}_${policy_variable}_${HORIZON}.pdf", replace 
}
}

